/*
 * Decompiled with CFR 0.152.
 */
package com.morallenplay.vanillacookbook.item;

import com.morallenplay.vanillacookbook.setup.Config;
import com.morallenplay.vanillacookbook.util.TooltipUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TooltipItem
extends Item {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;

    public TooltipItem(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = false;
        this.hasCustomTooltip = false;
    }

    public TooltipItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.hasCustomTooltip = false;
    }

    public TooltipItem(Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip) {
        super(properties);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.hasCustomTooltip = hasCustomTooltip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (this.hasCustomTooltip && ((Boolean)Config.FOOD_SPECIAL_TOOLTIPS.get()).booleanValue()) {
            MutableComponent textEmpty = TooltipUtils.getTranslation("tooltip." + this, new Object[0]);
            tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
        }
        if (this.hasFoodEffectTooltip && ((Boolean)Config.FOOD_EFFECT_TOOLTIPS.get()).booleanValue()) {
            TooltipUtils.addFoodEffectTooltip(stack, tooltip, 1.0f);
        }
    }
}

